using UnityEngine;
using System.Collections;

public class s_Enemy : s_PhysicsBase
{
	public Vector3 mDirection;
	
	s_Killable mKillScript;
	bool mHasRewind = false;	//Checks if you have a rewindable attached
	bool mFirstRewindFrame;		//This is so it won't change directions if you rewind for one frame
	int mSaveFrame = -1;		//Normally, every n frames that are recorded.
	int mSaveFrameAir = 5;		//In the air, every nth frame that is recorded.
	
	void Start()
	{	
		//Check if you have a rewindable
		if (GetComponent<s_Rewindable>() != null)
		{
			mHasRewind = true;
			GetComponent<s_Rewindable>().mRecordFrame = mSaveFrame; //Enemy takes care of its own recording
		}
		
		//Check if you have an animation
		if (GetComponent<s_AnimationBase>() != null)
			GetComponent<s_AnimationBase>().mMoveTol = 0; //Will only stop its animation when completely stopped
		
		if (GetComponent<s_Killable>() != null)
		{
			mKillScript = GetComponent<s_Killable>();
			mKillScript.mDieSound = s_AudioManager.Get.mEnemyDie;
		}
	}
	
	void Update()
	{
		if (mKillScript != null && mKillScript.mWasDead || mKillScript.mDead)
		{
			mKillScript.UpdateDead(); //Dead Update
			
			if (mKillScript.mDead)
				return;
		}
		
		if (mHasRewind && s_TimeManager.sRewind)
			UpdateRewindDirection(); // Rewind Update
		else
			ProcessMovement(); //Forward Update
	}
	
	void ProcessMovement()
	{	
		mFirstRewindFrame = true;
		
		//Set up movement
		mVerticalVelocity = mMoveVector.y;
		mMoveVector = mDirection;
		
		Move();
		
		CheckSaveAir();
	}
	
	void CheckSaveAir()
	{
		//If you are in the air, save every couple of frames.
		if (mHasRewind)
		{
			if (IsGrounded(gameObject) && GetComponent<s_Rewindable>().mRecordFrame == mSaveFrameAir)
				GetComponent<s_Rewindable>().mRecordFrame = mSaveFrame;
			else if (!IsGrounded(gameObject) && GetComponent<s_Rewindable>().mRecordFrame == mSaveFrame)
				GetComponent<s_Rewindable>().mRecordFrame = mSaveFrameAir;
		}
	}
	
	void UpdateRewindDirection()
	{	
		//Moving to the left
		if (transform.localScale.x > 0 && mDirection.x > 0)
		{
			if (mFirstRewindFrame)
			{
				mFirstRewindFrame = false;
				return;
			}
			
			mDirection *= -1;
		}
		//Moving to the right
		if (transform.localScale.x < 0 && mDirection.x < 0)
		{
			if (mFirstRewindFrame)
			{
				mFirstRewindFrame = false;
				return;
			}
			
			mDirection *= -1;
		}

	}
	
	void OnTriggerEnter(Collider other)
	{
		//Only if not rewinding
		if (mHasRewind && !s_TimeManager.sRewind || !mHasRewind)
		{
			//Hit Player
			if (other.gameObject.tag == "Player")
				HitPlayer(other.gameObject);
			//Hit some sort of geometry
			else
			{	
				//The floor
				if (mHasRewind && other.transform.position.y < transform.position.y - collider.bounds.extents.y)
					return;
				//A wall
				else if (mDirection.x < 0 && other.transform.position.x < transform.position.x //Left wall
					  || mDirection.x > 0 && other.transform.position.x > transform.position.x)//Right wall
				{
					if (mHasRewind)
						SavePosition();
					
					mDirection *= -1;
					Move();
				}
			}
		}
	}
	
	void HitPlayer(GameObject aPlayer)
	{
		// If the player jumps on the enemy, enemy dies
		if (aPlayer.collider.bounds.center.y - 0.75f  > transform.position.y)
		{
			aPlayer.gameObject.GetComponent<s_Player>().Jump();
			SavePosition();
			//s_AudioManager.Get.PlaySound(s_AudioManager.Get.mEnemyDie);
			mKillScript.Kill();
		}
		// Otherwise the player is dead
		else
		{
			aPlayer.GetComponent<s_Player>().SavePosition();
			//s_AudioManager.Get.PlaySound(s_AudioManager.Get.mPlayerDie);
			aPlayer.GetComponent<s_Killable>().Kill();
		}
	}
	
	void SavePosition()
	{
		if (mHasRewind)
			GetComponent<s_Rewindable>().AddCurrentPosition();;
	}
}